/**
 *
 * \file        cbuffer.h
 * \brief       circular buffer class
 * \author      Larry Salant
 * \date        4/25/2008
 *
 */
#ifndef _DM_CBUFFER_H_
#define _DM_CBUFFER_H_

#include "dm_nutypedefs.h"

#define CBUFFER_WIDTH_BYTE 1
#define CBUFFER_WIDTH_POINTER 4

class CBuffer
{
public:
  CBuffer (UINT16 sItems, UINT8 bWidth);
  ~CBuffer();
  UINT8 Read (void);
  void Write (UINT8 value);
  void CopyToLinear(UINT8 *pBuffer, UINT16 sMaxBytes);
  UINT32 ReadLong(void);
  void WriteLong(UINT32 lItem);
  BOOL IsEmpty(void);
  BOOL IsFull(void);

  //Debug variables
  UINT8 GetFullCount(void);
  INT16 GetMaxDepth(void);

private:
  UINT8 *m_pBuffer;
  UINT16 m_Size;
  UINT16 m_ReadFrom;
  UINT16 m_WriteTo;
  BOOL m_empty;
  BOOL m_full;

  UINT8 m_fullcount;   //for tuning track how often buffer is filled
  INT16 m_maxDepth;
};

#endif // _DM_CBUFFER_H_
